'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Binary       'Binary wichtig fr .LastModified !
Option Explicit

Private Sub Button_Matrix_KalenderKategorien_Click()
On Error GoTo Err_Button_Matrix_KalenderKategorien_Click
    
    'Hinweis zum Warten anzeigen
    DoCmd.OpenForm "Bitte_warten"
    Forms![Bitte_warten].Repaint
    
    Dim dbs As Database, rst As Recordset

    'Gre des Reportfensters und Berichts-Zoom optimieren
    'erst Fensterbreite und -hhe ermitteln, und nach dem ffnen des Reports anpassen
    AnwendungGroesseErmitteln
    
    'Formular anzeigen
    '  Anstatt der Eigenschaften-Bezeichner werden die Kennziffern verwendet!:
    '  DoCmd.OpenForm "Matrix_KalenderKategorien", acFormPivotTable, , , acFormReadOnly, acWindowNormal
    DoCmd.OpenForm "Matrix_KalenderKategorien", 4, , , 2, 0
    
    'Berichtsfenster nun auf Anwendungsgre zoomen
    DoCmd.MoveSize 0, 0, FormularBreite, FormularHoehe


Exit_Button_Matrix_KalenderKategorien_Click:
    Exit Sub

Err_Button_Matrix_KalenderKategorien_Click:
    MsgBox err.Description
    Resume Exit_Button_Matrix_KalenderKategorien_Click



End Sub

Private Sub Button_Matrix_KalenderKategorien_Exel_Click()
On Error GoTo Err_Button_Matrix_KalenderKategorien_Exel_Click__DateiSuchen
    
    'Hinweis zum Warten anzeigen
    DoCmd.OpenForm "Bitte_warten"
    Forms![Bitte_warten].Repaint
    
    Dim dbs As Database, rst As Recordset
    
    Dim xlAnw As Object                  '(Object) eigentlich "As Excel.Application"
    
    Dim sDrive As String
    Dim sPath As String
    Dim sFilename As String
    Dim sExtension As String
    Dim sSourcePath As String
    Dim AktVerzeichnis As String
    
    Dim VerzProgramm As String
    Dim VerzDaten As String
    Dim VerzMatrix As String
    Dim DatenDatei As String
    Dim pos As Integer
    Dim Gefunden As Boolean
    Dim ExcelDatei As String
    
    
    

    'Ermittlung des ProgrammDatei-Verzeichnisses
    VerzProgramm = ""
    VerzProgramm = Left(CurrentDb.Name, Len(CurrentDb.Name) - Len(Dir(CurrentDb.Name)))
    
    'Ermittlung des DatenDatei-Verzeichnisses
    'Aktuellen Daten-Dateipfad holen
    Set dbs = CurrentDb
    Set rst = dbs.OpenRecordset("Datenbankpfad")
    If rst.RecordCount > 0 Then
        'auffllen
        rst.MoveLast
        rst.MoveFirst
    End If
    DatenDatei = ""
    DatenDatei = rst!Quelle
    rst.Close
    'Verzeichnis ohne Dateinamen
    VerzDaten = ""
    VerzDaten = Left(DatenDatei, Len(DatenDatei) - Len(Dir(DatenDatei)))
    
    'Ermittlung des ExcelMatrix-Verzeichnisses
    For pos = Len(Matrix_KalenderKategorie_ExcelDatei) To 0 Step -1
        If pos = 0 Then Exit For
        If (Mid(Matrix_KalenderKategorie_ExcelDatei, pos, 1) = "\") Or (Mid(Matrix_KalenderKategorie_ExcelDatei, pos, 1) = "\") Then Exit For
    Next pos
    VerzMatrix = ""
    If pos <> 0 Then VerzMatrix = Left(Matrix_KalenderKategorie_ExcelDatei, pos)
    
    
    'Prfen, ob eine Excel-Datei in den Einstellungen angegeben wurde,
    'und ob diese Datei existiert
    Gefunden = False
    If Len(Trim(Matrix_KalenderKategorie_ExcelDatei)) = 0 Then
        On Error Resume Next
        DoCmd.Close acForm, "Bitte_warten", acSaveYes
        MsgBox "In den Einstellungen wurde kein Dateiname fr die Excel-Datei zur Anzeige der Kalender/Kategorie-Matrix angegeben.", vbCritical + vbOKOnly, "Fehler"
        Exit Sub
    End If
    '1. Prfung: wenn Excel-Verzeichnis angegeben wurde
    If VerzMatrix <> "" Then
        'wenn Excel-Datei mit Verzeichnis in den Einstellungen angegeben wurde
        If Dir(Matrix_KalenderKategorie_ExcelDatei) <> "" Then Gefunden = True
    End If
    If Gefunden = True Then
        ExcelDatei = Matrix_KalenderKategorie_ExcelDatei
    Else
        '2. Prfung: ob im DatenDatei-Verzeichnis abgelegt
        ExcelDatei = VerzDaten & Matrix_KalenderKategorie_ExcelDatei
        If Dir(ExcelDatei) <> "" Then Gefunden = True
    End If
    If Gefunden = False Then
        '3. Prfung: ob im ProgrammDatei-Verzeichnis abgelegt
        ExcelDatei = VerzProgramm & Matrix_KalenderKategorie_ExcelDatei
        If Dir(ExcelDatei) <> "" Then Gefunden = True
    End If
    'Abbruch, falls Excel-Datei nicht gefunden wurde
    If Gefunden = False Then
        On Error Resume Next
        DoCmd.Close acForm, "Bitte_warten", acSaveYes
        MsgBox "Die in den Einstellungen angegebene Excel-Datei fr die Anzeige der Kalender/Kategorie-Matrix wurde nicht gefunden." & _
            vbNewLine & vbNewLine & "Bitte geben Sie in den Einstellungen den Dateinamen mit Verzeichnis ein, " & _
            "oder speichern Sie die Excel-Datei ins Daten- oder Programmverzeichnis der Terminabrechnung.", vbOKOnly + vbCritical, "Fehler"
        Exit Sub
    End If
    
    
    
    'Versuch, Excel zu initialisieren und die Datei zu ffnen
    On Error GoTo Err_Button_Matrix_KalenderKategorien_Exel_Click__ExcelStarten
    Set xlAnw = CreateObject("Excel.Application")
    
    On Error GoTo Err_Button_Matrix_KalenderKategorien_Exel_Click__DateiInExelOeffnen
    xlAnw.Workbooks.Open FileName:=ExcelDatei, UpdateLinks:=0                   '0 = keine Aktualisierung externer Bezge
    
    
'Funktioniert nur nicht, da Daten-Datei bereits/noch von Access geffnet ist:
'----------------------------------------------------------------------------
'
'    'Aktualisierung der Verbindungsdefinition
'    With xlAnw.ActiveWorkbook.Connections("Termine_Daten__Matrix_KalenderKategorie").OLEDBConnection
'        .BackgroundQuery = True
'        .CommandText = Array( _
'        "SELECT DISTINCTROW Termine.S_Jahr AS Jahr, Kalender.Name AS Kalender, Kategorien.Name1 AS Kategorie, (Sum(Termine.Dauer)/60) AS Stunden, " _
'        , "Count(*) AS Termine" & Chr(13) & "" & Chr(10) & "FROM Kategorien INNER JOIN (Termine INNER JOIN Kalender ON Termine.lfd_Nr_Kalender = " _
'        , "Kalender.lfd_Nr) ON Kategorien.lfd_Nr = Termine.lfd_Nr_Kategorie" & Chr(13) & "" & Chr(10) & "GROUP BY Termine.S_Jahr, Kalender.Name, " _
'        , "Kategorien.Name1" & Chr(13) & "" & Chr(10) & "ORDER BY Termine.S_Jahr;")
'        .CommandType = xlCmdSql
'        .Connection = Array( _
'        "OLEDB;Provider=Microsoft.ACE.OLEDB.12.0;User ID=Admin;Data Source=" & AktVerzeichnis & ";Mode=Share Deny Write;Extended Properties="""";" _
'        , "Jet OLEDB:System database="""";Jet OLEDB:Registry Path="""";Jet OLEDB:Engine Type=5;" _
'        , "Jet OLEDB:Database Locking Mode=0;Jet OLEDB:Global Partial Bulk Ops=2;Jet OLEDB:Global Bulk Transactions=1;Jet OLEDB:New Database Password="""";" _
'        , "Jet OLEDB:Create System Database=False;Jet OLEDB:Encrypt Database=False;Jet OLEDB:Don't Copy Locale on Compact=False;" _
'        , "Jet OLEDB:Compact Without Replica Repair=False;Jet OLEDB:SFP=False;Jet OLEDB:Support Complex Data=False;Jet OLEDB:Bypass UserInfo Validation=False")
'        .RefreshOnFileOpen = False
'        .SavePassword = False
'        .SourceConnectionFile = ""
'        .SourceDataFile = AktVerzeichnis
'        .ServerCredentialsMethod = xlCredentialsMethodIntegrated
'        .AlwaysUseConnectionFile = False
'        '.ServerFillColor = False
'        '.ServerFontStyle = False
'        '.ServerNumberFormat = False
'        '.ServerTextColor = False
'    End With
    
    On Error GoTo Err_Button_Matrix_KalenderKategorien_Exel_Click__SourceAuslesen
    sSourcePath = xlAnw.ActiveWorkbook.Connections(1).OLEDBConnection.Connection
    sSourcePath = Mid(sSourcePath, InStr(1, sSourcePath, "Data Source=", vbTextCompare) + 12, (InStr(InStr(1, sSourcePath, "Data Source=", vbTextCompare) + 12, sSourcePath, ";", vbTextCompare)) - (InStr(1, sSourcePath, "Data Source=", vbTextCompare) + 12))
    'MsgBox xlAnw.ActiveWorkbook.Connections(1).OLEDBConnection.Connection
    'MsgBox sSourcePath
    
    'Prfung, ob der Pfad in der Excel-Abfrage auf die Access-Datendatei zeigt
    'If xlAnw.ActiveWorkbook.Connections("Termine_Daten__Matrix_KalenderKategorie").OLEDBConnection.SourceDataFile <> AktVerzeichnis Then
    'If sSourcePath <> AktVerzeichnis Then
    If sSourcePath <> DatenDatei Then
        MsgBox "Die Datenabfrage in der Excel-Datei zeigt auf eine andere Datenbank:" & _
            vbNewLine & vbNewLine & "Excel-Datei:" & vbNewLine & "[" & sSourcePath & "]" & _
            vbNewLine & vbNewLine & "Terminabrechnung:" & vbNewLine & "[" & DatenDatei & "]" & vbNewLine & vbNewLine & _
            "Bitte passen Sie in der Excel-Datei die Verknpfung an.", vbInformation + vbOKOnly, "Hinweis"
        ' drittes Tabellenblatt in den Focus holen (mit dem Button zur Datei-Suche)
        On Error GoTo Err_Button_Matrix_KalenderKategorien_Exel_Click__Sheet3
        xlAnw.Sheets(3).Select
    Else
        ' Erstes Tabellenblatt in den Focus holen
        On Error GoTo Err_Button_Matrix_KalenderKategorien_Exel_Click__Sheet1
        xlAnw.Sheets(1).Select
    End If
    
    'Excel-Datei sichtbar machen
    xlAnw.Visible = True
    
    On Error Resume Next
    DoCmd.Close acForm, "Bitte_warten", acSaveYes
    
    MsgBox "Bevor Sie in Excel weiterarbeiten, schlieen Sie bitte Access!", vbOKOnly + vbExclamation, "Achtung"
    
    
    Exit Sub
    
    
Exit_Button_Matrix_KalenderKategorien_Exel_Click:
    On Error Resume Next
    Set xlAnw = Nothing
    DoCmd.Close acForm, "Bitte_warten", acSaveYes
    Exit Sub
    
    
Err_Button_Matrix_KalenderKategorien_Exel_Click__DateiSuchen:
    MsgBox "Bei dem Versuch, die in den Einstellungen angegebene Excel-Datei zur Anzeige der Kalender/Kategorie-Matrix zu suchen,  ist ein Fehler aufgetreten." & _
        vbNewLine & vbNewLine & "Fehler # " & err.Number & " verursacht in " & err.Source & " => " & err.Description, vbOKOnly + vbCritical, "Fehler"
    Resume Exit_Button_Matrix_KalenderKategorien_Exel_Click
    
Err_Button_Matrix_KalenderKategorien_Exel_Click__ExcelStarten:
    MsgBox "Bei dem Versuch, Excel im Hintergrund zu starten, ist ein Fehler aufgetreten." & _
        vbNewLine & vbNewLine & "Fehler # " & err.Number & " verursacht in " & err.Source & " => " & err.Description, vbOKOnly + vbCritical, "Fehler"
    Resume Exit_Button_Matrix_KalenderKategorien_Exel_Click
    
Err_Button_Matrix_KalenderKategorien_Exel_Click__DateiInExelOeffnen:
    MsgBox "Bei dem Versuch, die Datei [" & ExcelDatei & "] in Excel zu ffnen, ist ein Fehler aufgetreten." & _
        vbNewLine & vbNewLine & "Fehler # " & err.Number & " verursacht in " & err.Source & " => " & err.Description, vbOKOnly + vbCritical, "Fehler"
    Resume Exit_Button_Matrix_KalenderKategorien_Exel_Click
    
Err_Button_Matrix_KalenderKategorien_Exel_Click__SourceAuslesen:
    MsgBox "Bei dem Versuch, in der Excel-Datei die Verknpfung zur Datenquelle zu ermitteln, ist ein Fehler aufgetreten." & _
        vbNewLine & "Bitte prfen Sie in der Excel-Datei, ob diese mit der richtigen Daten-Datei verbunden ist." & _
        vbNewLine & vbNewLine & "Fehler # " & err.Number & " verursacht in " & err.Source & " => " & err.Description, vbOKOnly + vbInformation, "Hinweis"
    'Excel-Datei sichtbar machen
    On Error Resume Next
    xlAnw.Visible = True
    Exit Sub
    
Err_Button_Matrix_KalenderKategorien_Exel_Click__Sheet3:
    MsgBox "Bei dem Versuch, in der Excel-Datei das 3. Tabellenblatt zu aktivieren, ist ein Fehler aufgetreten." & _
        vbNewLine & vbNewLine & "Fehler # " & err.Number & " verursacht in " & err.Source & " => " & err.Description, vbOKOnly + vbInformation, "Hinweis"
    'Excel-Datei sichtbar machen
    On Error Resume Next
    xlAnw.Visible = True
    Exit Sub

Err_Button_Matrix_KalenderKategorien_Exel_Click__Sheet1:
    MsgBox "Bei dem Versuch, in der Excel-Datei das 1. Tabellenblatt zu aktivieren, ist ein Fehler aufgetreten." & _
        vbNewLine & vbNewLine & "Fehler # " & err.Number & " verursacht in " & err.Source & " => " & err.Description, vbOKOnly + vbInformation, "Hinweis"
    'Excel-Datei sichtbar machen
    On Error Resume Next
    xlAnw.Visible = True
    Exit Sub

Err_Button_Matrix_KalenderKategorien_Exel_Click:
    MsgBox err.Description
    Resume Exit_Button_Matrix_KalenderKategorien_Exel_Click


End Sub

Private Sub Button_Tabellenansicht_Click()
On Error GoTo Err_Button_Tabellenansicht_Click
    
    'Hinweis zum Warten anzeigen
    DoCmd.OpenForm "Bitte_warten"
    Forms![Bitte_warten].Repaint
    
    Dim dbs As Database, rst As Recordset

    'Gre des Reportfensters und Berichts-Zoom optimieren
    'erst Fensterbreite und -hhe ermitteln, und nach dem ffnen des Reports anpassen
    AnwendungGroesseErmitteln
    
    'Formular anzeigen
    DoCmd.OpenForm "Termine_alsTabelle", acFormDS, , , acFormReadOnly, acWindowNormal
    'Filter fr Termine setzen
    Forms.Item("Termine_alsTabelle").FilterOn = False
    Forms.Item("Termine_alsTabelle").Filter = "((([S_Jahr]=" & Me.Jahresauswahl.Value & ") OR ([E_Jahr]=" & Me.Jahresauswahl.Value & "))" & _
        " OR (([S_Jahr]<" & Me.Jahresauswahl.Value & ") AND ([E_Jahr]>" & Me.Jahresauswahl.Value & "))) AND [lfd_Nr_Kategorie]=" & AktKategorie
    'Evtl. Einschrnkung auf einen Kalender bercksichtigen
    '  (nur bei aktiven Terminen, gelschte Termine haben keine Kalenderzuordnung)
    If (Me.Kalenderauswahl.DefaultValue = 1) And (Not IsNull(Me.Kalender_direkt.Value)) Then
        Forms.Item("Termine_alsTabelle").Filter = Forms.Item("Termine_alsTabelle").Filter & " AND ([lfd_Nr_Kalender]=" & Me.Kalender_direkt.Value & ")"
    End If
    Forms.Item("Termine_alsTabelle").FilterOn = True
    'Sortierreihenfolgen setzen
    Forms.Item("Termine_alsTabelle").OrderByOn = False
    Forms.Item("Termine_alsTabelle").OrderBy = "Termine.Start"
    Forms.Item("Termine_alsTabelle").OrderByOn = True
    Forms.Item("Termine_alsTabelle").Requery
    
    'Berichtsfenster nun auf Anwendungsgre zoomen
    DoCmd.MoveSize 0, 0, FormularBreite, FormularHoehe


Exit_Button_Tabellenansicht_Click:
    Exit Sub

Err_Button_Tabellenansicht_Click:
    MsgBox err.Description
    Resume Exit_Button_Tabellenansicht_Click


End Sub

Private Sub Form_AfterUpdate()
    'falls bei nderung der Name1 gendert wurde, das Suchfeld aktualisieren
    Me.Suchfeld.Requery
    'weitere Einstellungen vornehmen (Detailtabellen auf eingestelltes Jahr filtern - erzwingen)
    Jahresauswahl_Change
    
End Sub

Private Sub Form_Current()
    'falls per Navigator der Datensatz gewechselt wird, Sucheld mit akt. Satz synchronisieren
    Me.Suchfeld.DefaultValue = Me.lfd_Nr.Value
    'aktuelle Kundennr. merken
    AktKategorie = Me.lfd_Nr.Value
    
    'auf Dummy-Kategorie prfen
    If Me.Kategorie_ID.Value = KategorieDummy Then
        Me.MwSt_indiv.Enabled = False
        Me.lfd_Nr_MwSteuer.Enabled = False
    Else
        Me.MwSt_indiv.Enabled = True
        Me.lfd_Nr_MwSteuer.Enabled = True
    End If
    
    'Me.KontaktOeffnenBild.HyperlinkAddress = "outlook:" & Me.Kunden_ID
End Sub

Private Sub Form_Load()
    On Error Resume Next
    DoCmd.Close acForm, "Bitte_warten", acSaveYes
End Sub

Private Sub Form_Open(Cancel As Integer)
    'Datensatz vor Aktualisierung anzeigen
    'Me.Suchfeld.DefaultValue = KundenNrIntern
    Me.Suchfeld.DefaultValue = AktKategorie
    Suchfeld_AfterUpdate
''    'Bereich vor Aktualisierung einstellen
''    If FormularBereich = "Gebuehren" Then Button_Gebuehren_Click
''    If FormularBereich = "Rechnungen" Then Button_Rechnungen_Click
''    If FormularBereich = "Termine" Then Button_Termine_Click
    
    FormularName = "Kategorien"

    'Jahr einstellen
    Me.Jahresauswahl.DefaultValue = Year(Now())
    If Month(Now()) = 1 Then
        Me.Jahresauswahl.DefaultValue = Year(Now()) - 1
    End If
    Me.Jahresauswahl.RowSource = "SELECT DISTINCTROW [Abf_Term_SuDauerJahr].[S_Jahr] FROM [Abf_Term_SuDauerJahr] ORDER BY  [Abf_Term_SuDauerJahr].[S_Jahr] DESC;"
    'Sortierreihenfolge des Formulares auf Name1 aufsteigend stellen
    Me.OrderByOn = False
    Me.OrderBy = "Kategorien.Name1"
    Me.OrderByOn = True
    'weitere Einstellungen vornehmen
    Jahresauswahl_Change
    'aktuelle Kundennummer merken fr Datensatznavigator
    KategorieAlt = AktKategorie
    
    'Richtigen Button fr Matrix Kalender/Kategorie aktivieren:
    'zunchst fr Excel-Ansicht aktivieren
    Me.Button_Matrix_KalenderKategorien.Visible = False
    Me.Button_Matrix_KalenderKategorien_Exel.Visible = True
    If Matrix_KalenderKategorie_ExcelJaNein = True Then
        'falls Formularansicht gewnscht, Access-Version prfen und Formular-Ansicht aktivieren
        If (Fix(Val(SysCmd(acSysCmdAccessVer))) >= 12) And (Fix(Val(SysCmd(acSysCmdAccessVer))) <= 14) Then
            'nur bei Access 2007 und 2010 Formular-Ansicht aktivieren
            Me.Button_Matrix_KalenderKategorien.Visible = True
            Me.Button_Matrix_KalenderKategorien_Exel.Visible = False
        End If
    End If
    
End Sub

Private Sub Form_Timer()
    'Prfen, ob der Datensatz per Datensatznavigator weiterbewegt wurde und
    'Unter-Formulare erneut auf angezeigtes Jahr filtern.
    '(Ist an dieser Stelle notwendig, da das Einfgen der Procedure "Jahresauswahl_Change" in
    'die "Current"-Eigenschaft des Haupt-Formulares zu einem Fehler fhrt.)
    If KategorieAlt <> AktKategorie Then
        Jahresauswahl_Change
        KategorieAlt = AktKategorie
    End If
End Sub

Private Sub Haken_geloeschte_Termine_AfterUpdate()
    If Me.Haken_geloeschte_Termine.Value = 0 Then
        'Aktive Termine anzeigen
''        Me.Haken_Kalender.Enabled = True
        Me.Haken_geloeschte_Termine_Bez.ForeColor = 0
        Me.Termine.Form.Visible = True
        Me.Termine_geloescht.Form.Visible = False
        Me.Button_Tabellenansicht.Enabled = True
        'Kalenderauswahl aktivieren
        Me.Kalenderauswahl.Enabled = True
        Me.Kalender_direkt.Enabled = True
    Else
        'gelschte Termine anzeigen
''        Me.Haken_Kalender.Enabled = False
        Me.Haken_geloeschte_Termine_Bez.ForeColor = 255
        Me.Termine.Form.Visible = False
        Me.Termine_geloescht.Form.Visible = True
        Me.Button_Tabellenansicht.Enabled = False
        'Kalenderauswahl deaktivieren
        Me.Kalenderauswahl.Enabled = False
        Me.Kalender_direkt.Enabled = False
    End If
    
    'Tabellen erneut auf das ausgewhlte Jahr filtern
    Jahresauswahl_Change

End Sub

Private Sub Jahresauswahl_AfterUpdate()
    Jahresauswahl_Change
End Sub

Private Sub Jahresauswahl_Change()
    'Filter fr Termine setzen
    'Me.Termine.Form.FilterOn = False
    Me.Termine.Form.Filter = "((([S_Jahr]=" & Me.Jahresauswahl.Value & ") OR ([E_Jahr]=" & Me.Jahresauswahl.Value & "))" & _
        " OR (([S_Jahr]<" & Me.Jahresauswahl.Value & ") AND ([E_Jahr]>" & Me.Jahresauswahl.Value & ")))"
    'Evtl. Einschrnkung auf einen Kalender bercksichtigen
    '  (nur bei aktiven Terminen, gelschte Termine haben keine Kalenderzuordnung)
    If (Me.Kalenderauswahl.DefaultValue = 1) And (Not IsNull(Me.Kalender_direkt.Value)) Then
        Me.Termine.Form.Filter = Me.Termine.Form.Filter & " AND ([lfd_Nr_Kalender]=" & Me.Kalender_direkt.Value & ")"
    End If
    Me.Termine.Form.FilterOn = True
    Me.Termine.Form.Requery
    'Me.Termine_geloescht.Form.FilterOn = False
    Me.Termine_geloescht.Form.Filter = "((([S_Jahr]=" & Me.Jahresauswahl.Value & ") OR ([E_Jahr]=" & Me.Jahresauswahl.Value & "))" & _
        " OR (([S_Jahr]<" & Me.Jahresauswahl.Value & ") AND ([E_Jahr]>" & Me.Jahresauswahl.Value & ")))"
    Me.Termine_geloescht.Form.FilterOn = True
    Me.Termine_geloescht.Form.Requery
''    'Filter fr Kalender setzen
''    Me.Kalender.Form.FilterOn = False
''    Me.Kalender.Form.Filter = "[Jahr]=" & Me.Jahresauswahl.Value
''    Me.Kalender.Form.FilterOn = True
''    'Filter fr Rechnungsliste setzen
''    Me.Rechnungen.Form.FilterOn = False
''    Me.Rechnungen.Form.Filter = "[Re_Jahr]=" & Me.Jahresauswahl.Value
''    Me.Rechnungen.Form.FilterOn = True
    'Sortierreihenfolgen in den Unterformularen setzen
    Me.Termine.Form.OrderByOn = False
    Me.Termine.Form.OrderBy = "Termine.Start"
    Me.Termine.Form.OrderByOn = True
    Me.Termine_geloescht.Form.OrderByOn = False
    Me.Termine_geloescht.Form.OrderBy = "[Termine_geloescht].[Start]"
    Me.Termine_geloescht.Form.OrderByOn = True
''    Me.Rechnungen.Form.OrderByOn = False
''    Me.Rechnungen.Form.OrderBy = "[Rechnungen].[Re_Nr]"
''    Me.Rechnungen.Form.OrderByOn = True
''    Me.Gebuehren.Form.OrderByOn = False
''    Me.Gebuehren.Form.OrderBy = "[Gebuehren].[gilt_ab] DESC"
''    Me.Gebuehren.Form.OrderByOn = True
''    'Button zum Aktivieren von Terminen mit negativem Saldo deaktivieren
''    TerminAktivieren.Visible = False
    
    'Texteingabe fr "(ohne Kategorie)" deaktivieren, sonst aktivieren
    If Me.Kategorie_ID = KategorieDummy Then
        Me.Kategorie.Enabled = False
    Else
        Me.Kategorie.Enabled = True
    End If
    
    'Kategoriefarbe fr den berschriftenbereich in der Untertabelle bernehmen
    'Me.Termine.Form.Section(1).BackColor = RGB(Me.Rot, Me.Gruen, Me.Blau)      'Section(1) = Formularkopfbereich
    Me.FarbRechteck.BackColor = RGB(Me.Rot, Me.Gruen, Me.Blau)
    
End Sub

Private Sub Kalender_alle_MouseDown(Button As Integer, Shift As Integer, x As Single, y As Single)
    Me.Kalenderauswahl.DefaultValue = 0
    Jahresauswahl_Change
End Sub

Private Sub Kalender_direkt_AfterUpdate()
    Jahresauswahl_Change
End Sub

Private Sub Kalender_direkt_GotFocus()
    Me.Kalenderauswahl.DefaultValue = 1
End Sub

Private Sub Kalender_direkt_LostFocus()
    If IsNull(Me.Kalender_direkt.Value) Then Me.Kalenderauswahl.DefaultValue = 0
End Sub

Private Sub Kalender_nur_MouseDown(Button As Integer, Shift As Integer, x As Single, y As Single)
    Me.Kalenderauswahl.DefaultValue = 1
    Me.Kalender_direkt.SetFocus
    Jahresauswahl_Change
End Sub

Private Sub Kategorie_LostFocus()
    'Verhinderung des Feldinhaltes "Null", da dies spter bei Abfragen zu Fehlern fhrt
    If Len(Trim(Me.Kategorie.Text)) = 0 Then Me.Kategorie = " "
End Sub

Private Sub MwSt_indiv_Click()
    If Me.MwSt_indiv.Value = True Then
        Me.lfd_Nr_MwSteuer.SetFocus
        Me.lfd_Nr_MwSteuer.Dropdown
    End If
End Sub

Private Sub Suchfeld_AfterUpdate()
    ' Den mit dem Steuerelement bereinstimmenden Datensatz suchen.
    On Error Resume Next                            'falls Kundentabelle leer ist
    Me.RecordsetClone.FindFirst "[lfd_Nr] = " & Me![Suchfeld]
    Me.Bookmark = Me.RecordsetClone.Bookmark
End Sub

Private Sub Fenster_schliessen_Click()
On Error GoTo Err_Fenster_schliessen_Click


    DoCmd.Close

Exit_Fenster_schliessen_Click:
    Exit Sub

Err_Fenster_schliessen_Click:
    MsgBox err.Description
    Resume Exit_Fenster_schliessen_Click
    
End Sub
